/**
* \file: PfCfgConfiguration.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_PFCFGCONFIGURATION_H
#define CARPLAY_PFCFGCONFIGURATION_H

#include <list>
#include <string>
#include "Common.h"
#include "utils/Statistics.h"

namespace adit { namespace carplay
{

class CARPLAY_HIDDEN PfCfgConfiguration : public IDynamicConfiguration, public IStatisticsProvider
{
public:
    static PfCfgConfiguration* FromFile(const std::string& fileName);

    virtual ~PfCfgConfiguration();

    void SetItem(const std::string& key, const std::string& value);
    bool TryGetItem(const std::string& key, std::string& result) const;

    std::list<std::string> GetItems(const std::string& key) const;

protected:
    std::list<std::string> GetStatistics();

private:
    PfCfgConfiguration();

    std::map<std::string, std::string> config;

    bool checkItem(const std::string& key, std::string& value) const;
    void insert(const std::string& key, const std::string& value);
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_PFCFGCONFIGURATION_H */
